/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.jms;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.integrator.adaptors.jms.VWEventItem;
import filenet.vw.integrator.adaptors.jms.VWEventPanel;
import filenet.vw.integrator.adaptors.jms.VWParameterItem;
import filenet.vw.integrator.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.w3c.dom.Node;

class VWJMSOperationsDialog
extends VWModalDialog
implements ActionListener {
    public static final int STATUS_CANCEL = 0;
    public static final int STATUS_OK = 1;
    private int m_nStatus = 0;
    private VWEventPanel m_eventPanel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;

    public VWJMSOperationsDialog(Frame parent, String componentDescriptor) throws Exception {
        super(parent);
        this.initialize(componentDescriptor);
    }

    public VWJMSOperationsDialog(Dialog parent, String componentDescriptor) throws Exception {
        super(parent);
        this.initialize(componentDescriptor);
    }

    public String[] getOperationDescriptors() {
        try {
            VWEventItem[] eventItems = this.m_eventPanel.getEventItems();
            if (eventItems != null && eventItems.length > 0) {
                String[] descriptors = new String[eventItems.length];
                for (int nIndex = 0; nIndex < eventItems.length; ++nIndex) {
                    descriptors[nIndex] = this.getOperationDescriptor(eventItems[nIndex]);
                }
                return descriptors;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object.equals(this.m_okButton)) {
            if (this.m_eventPanel != null) {
                this.m_eventPanel.stopEditing();
            }
            this.m_nStatus = 1;
            this.setVisible(false);
        } else if (object.equals(this.m_cancelButton)) {
            this.m_nStatus = 0;
            this.setVisible(false);
        } else if (object.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc083.htm");
        }
    }

    private void initialize(String componentDescriptor) {
        try {
            Dimension dim = VWStringUtils.stringToDimension(VWResource.s_jmsOperationsDialogDim);
            if (dim == null) {
                dim = new Dimension(600, 400);
            }
            this.setSize(dim);
            this.setTitle(VWResource.s_jmsOperationsDialogTitle);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.m_eventPanel = new VWEventPanel(this);
            this.getContentPane().add((Component)this.m_eventPanel, "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
            if (componentDescriptor != null && componentDescriptor.length() > 0) {
                VWXMLWrapper vWXMLWrapper = new VWXMLWrapper(componentDescriptor);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getButtonPanel() {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.setDefaultCapable(true);
            this.m_okButton.addActionListener(this);
            panel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            panel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            panel.add(this.m_helpButton);
            this.getRootPane().setDefaultButton(this.m_okButton);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private String getOperationDescriptor(VWEventItem eventItem) {
        try {
            VWXMLWrapper xmlWrapper = new VWXMLWrapper("fnpe_operation_descriptor", "http://www.filenet.com/xml/schemas/FNPE/1.0.0");
            Node rootNode = xmlWrapper.getRootNode();
            xmlWrapper.createNodeNamed(rootNode, "name", eventItem.getName());
            xmlWrapper.createNodeNamed(rootNode, "description", eventItem.getDescription());
            VWParameterItem[] parameters = eventItem.getParameterItems();
            if (parameters != null && parameters.length > 0) {
                for (int nIndex = 0; nIndex < parameters.length; ++nIndex) {
                    Node parameter = xmlWrapper.createNodeNamed(rootNode, "parameter", null);
                    xmlWrapper.createNodeNamed(parameter, "name", parameters[nIndex].getName());
                    xmlWrapper.createNodeNamed(parameter, "type", Integer.toString(parameters[nIndex].getType()));
                    xmlWrapper.createNodeNamed(parameter, "mode", Integer.toString(1));
                    xmlWrapper.createNodeNamed(parameter, "isarray", String.valueOf(parameters[nIndex].getIsArray()));
                    xmlWrapper.createNodeNamed(parameter, "description", parameters[nIndex].getDescription());
                }
            }
            return xmlWrapper.toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

